<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ObjectFieldInPermissionsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Adding object_id foreign key
        Schema::table('permission_roles', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(1)
                ->after('role_id');

            $table
                ->foreign('object_id')
                ->references('id')->on('objects')
                ->onDelete('cascade');
        });

        // Change primary key
        DB::statement('
            ALTER TABLE `permission_roles`
            ADD PRIMARY KEY `permission_id_role_id_object_id` (`permission_id`, `role_id`, `object_id`),
            DROP INDEX `PRIMARY`
        ');

        // Removing default value of object_id column
        Schema::table('permission_roles', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(null)
                ->change();
        });


        // Adding object_id foreign key
        Schema::table('permission_users', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(1)
                ->after('permission_id');

            $table
                ->foreign('object_id')
                ->references('id')->on('objects')
                ->onDelete('cascade');
        });

        // Change primary key
        DB::statement('
            ALTER TABLE `permission_users`
            ADD PRIMARY KEY `user_id_permission_id_object_id` (`user_id`, `permission_id`, `object_id`),
            DROP INDEX `PRIMARY`
        ');

        // Removing default value of object_id column
        Schema::table('permission_users', function (Blueprint $table) {
            $table
                ->unsignedInteger('object_id')
                ->default(null)
                ->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permission_roles', function (Blueprint $table) {
            // Change primary key
            DB::statement('
                ALTER TABLE `permission_roles`
                ADD PRIMARY KEY `permission_id_role_id` (`permission_id`, `role_id`),
                DROP INDEX `PRIMARY`
            ');

            // Drop object_id foreign key
            $table->dropForeign(['object_id']);
            $table->dropColumn('object_id');
        });

        Schema::table('permission_users', function (Blueprint $table) {
            // Change primary key
            DB::statement('
                ALTER TABLE `permission_users`
                ADD PRIMARY KEY `user_id_permission_id` (`user_id`, `permission_id`),
                DROP INDEX `PRIMARY`
            ');

            // Drop object_id foreign key
            $table->dropForeign(['object_id']);
            $table->dropColumn('object_id');
        });
    }
}
