<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddObjectIdColumnInAdvertsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('adverts', function (Blueprint $table) {
            $object = \App\Models\Building::first();
            if ($object) {
                $table->unsignedInteger('object_id')->after('id')->default($object->id);
            } else {
                $table->unsignedInteger('object_id')->after('id')->default(null);
            }

            $table->foreign('object_id')->references('id')->on('objects');
        });

        Schema::table('adverts', function (Blueprint $table) {
            $table->unsignedInteger('object_id')->default(NULL)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('adverts', function (Blueprint $table) {
            $table->dropForeign(['object_id']);
            $table->dropColumn(['object_id']);
        });
    }
}
