<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddObjectIdColumnInCallingPanelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('calling_panels', function (Blueprint $table) {
            $object = \App\Models\Building::first();
            $panel = \App\Models\CallingPanel::first();
            if ($panel && $object) {
                $table->integer('object_id')->after('dtmf_2')->default($object->id);
            } else {
                $table->integer('object_id')->after('dtmf_2');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('calling_panels', function (Blueprint $table) {
            $table->dropColumn(['object_id']);
        });
    }
}
