<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddObjectIdColumnInApartmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('apartments', function (Blueprint $table) {
            $object = \App\Models\Building::first();
            $apartment = \App\Models\Apartment::first();
            if ($apartment && $object) {
                $table->integer('object_id')->after('activation_code')->default($object->id);
            } else {
                $table->integer('object_id')->after('activation_code');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('apartments', function (Blueprint $table) {

            $table->dropColumn(['object_id']);
        });
    }
}
