<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCallingPanelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('calling_panels', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->comment('Имя');
            $table->string('sip_number')->comment('SIP номер');
            $table->string('rtsp_link')->nullable()->comment('Полная RTSP ссылка');
            $table->string('login')->nullable()->comment('Логин для RTSP ссылки');
            $table->string('password')->nullable()->comment('Пароль для RTSP ссылки');
            $table->string('ip_address')->nullable()->comment('IP адрес для RTSP ссылки');
            $table->integer('port')->nullable()->comment('Порт для RTSP ссылки');
            $table->string('dtmf_1')->comment('DTMF 1');
            $table->string('dtmf_2')->nullable()->comment('DTMF 2');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('calling_panels');
    }
}
