<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableAdvertsDestinations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('adverts_destinations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('floor')->nullable();
            $table->integer('apartment')->unsigned()->nullable();
            $table->integer('entrance')->unsigned()->nullable();
            $table->integer('advert_id')->unsigned();
            $table->boolean('is_all_house')->default(FALSE);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('adverts_destinations');
    }
}
