<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateQuizeTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quizzes', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title', 100)->comment('Заголовок опроса');
            $table->string('question', 1000)->comment('Текст вопроса');
            $table->boolean('free_answer')->default(0)->comment('Доступен свободный ответ: 0 - нет, 1 - да');
            $table->boolean('multiple')->default(0)->comment('Выбор нескольких вариантов ответа: 0 - нет, 1 - да');
            $table->boolean('allow_view_results')->default(0)->comment('Разрешен просмотр результатов: 0 - нет, 1 - да');
            $table->boolean('is_template')->default(0)->comment('Является ли опрос шаблоном: 0 - нет, 1 - да');
            $table->timestamp('start_at')->nullable()->comment('Дата начала опроса');
            $table->timestamp('end_at')->nullable()->comment('Дата окончания опроса');
            $table->boolean('active')->default(1)->comment('Активность элемента');
            $table->timestamps();
        });

        Schema::create('quiz_answer', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('quiz_id')->unsigned();
            $table->foreign('quiz_id')->references('id')->on('quizzes')->onDelete('cascade');
            $table->string('text',100)->comment('Текст варианта ответа');
            $table->timestamps();
        });

        Schema::create('quiz_result', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('quiz_id')->unsigned();
            $table->foreign('quiz_id')->references('id')->on('quizzes')->onDelete('cascade');
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('free_answer_value')->nullable();
            $table->integer('quiz_answer_id')->nullable()->unsigned();
            $table->foreign('quiz_answer_id')->references('id')->on('quiz_answer');
            $table->timestamps();
        });

        Schema::create('quiz_viewed', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('quiz_id')->unsigned();
            $table->foreign('quiz_id')->references('id')->on('quizzes')->onDelete('cascade');
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_viewed');
        Schema::dropIfExists('quiz_result');
        Schema::dropIfExists('quiz_answer');
        Schema::dropIfExists('quizzes');
    }
}
