<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCamerasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cameras', function (Blueprint $table) {
            $table->increments('id')->comment('ID камеры');
            $table->string('name')->comment('Название камеры');
            $table->string('model')->nullable()->comment('Модель камеры');
            $table->string('ip_address')->nullable()->comment('IP адрес камеры');
            $table->string('port')->nullable()->comment('Порт камеры');
            $table->string('login')->nullable()->comment('Логин для подключения к камере');
            $table->string('password')->nullable()->comment('Пароль для подключения к камере');
            $table->string('sip_number')->nullable()->comment('SIP номер для подключения к камере');
            $table->string('rtsp_link')->nullable()->comment('RTSP ссылка для получения видео с камеры');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cameras');
    }
}
