<?php

use Faker\Generator as Faker;

$factory->define(App\Models\Claim::class, function (Faker $faker) {
    return [
        'user_id' => factory(App\Models\User::class)->create()->id,
        'need_at' => $faker->dateTimeBetween('+1 day', '+1 month')->format('Y-m-d H:i:s'),
        'type_id' => factory(App\Models\ClaimType::class)->create()->id,
        'phone' => '79207623368',
        'status' => $faker->numberBetween(0,3),
        'apartment_id' => factory(App\Models\Apartment::class)->create()->id,
        'claim_text' => $faker->text(1000),
        'object_id' => factory(App\Models\Building::class)->create()->id,
    ];
});