<?php
namespace App\Traits;

trait SetSimpleCookie {
    protected function setCookie(string $name, string $value = '', int $time = null, string $path = '/')
    {
        if(!$time) {
            $time = 2147483647;
        }

        if (filter_input(INPUT_COOKIE, $name) !== $value) {
            setcookie($name, $value, $time, $path);
            return true;
        }

        return false;
    }

    protected function getCookie($cookie)
    {
        return filter_input(INPUT_COOKIE, $cookie);
    }
}
