<?php

namespace App\Rules\Users;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HaveAccessToEntry implements Rule
{
    protected $table;
    protected $column;
    protected $message;
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(string $table, string $column, string $message)
    {
        $this->table = $table;
        $this->column = $column;
        $this->message = 'validation.users.' . $message;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $roles)
    {
        // Пропускать только те роли, которые доступны текущему пользователю
        $pass = true;

        $roles->each(function ($role) use (&$pass) {
            if (!DB::table($this->table)->select($this->column)
                ->where('object_id', config('app.object.id'))
                ->where('user_id', Auth::user()->id)
                ->where($this->column, $role)
                ->count()) {
                $pass = false;

                return false;
            }
        });

        return $pass;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans($this->message);
    }
}
