<?php

namespace App\Rules;

use App\Models\PermissionManager\Permission;
use App\Traits\PermissionManager\GroupPermission;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class NotGreaterWeightPermissions implements Rule
{
    use GroupPermission;
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $request = $this->setGroupPermissions(request());

        return Auth::user()->getAllPermissionsWeight() >= Permission::getPermissionsWeight(
            $request->input('permissions'),
            $request->input('roles')
        );
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('validation.custom.greater_weight_permissions');
    }
}
