<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\ResetPassword as ResetPassword;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ResetPasswordNotification extends ResetPassword
{
    /**
     * Build the mail representation of the notification.
     *
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage())
            ->subject('Запрос на сброс пароля')
            ->line([
                'Вам пришло это письмо, потому что мы получили запрос на сброс пароля для Вашей учетной записи.',
                'Нажмите на кнопку ниже, чтобы сбросить пароль:',
            ])
            ->action('Сбросить пароль', url(config('backpack.base.route_prefix').'/password/reset', $this->token))
            ->line('Если вы не запрашивали сброс пароля, проигнорируйте это письмо.');
    }
}