<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use App\Notifications\Channels\GcmDataChannel;
use NotificationChannels\Gcm\GcmMessage;

class NewQuiz extends Notification
{
    use Queueable;

    protected $title;

    public function setName($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array
     */
    public function via()
    {
        return [GcmDataChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed $notifiable
     * @return \NotificationChannels\Gcm\GcmMessage;
     */
    public function toGcm($notifiable)
    {
        return GcmMessage::create()
            ->badge(1)
            ->title(__('quizzes.notifications.new_quiz', [], $notifiable->locale))
            ->message($this->title);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'badge' => 1,
            'title' => __('quizzes.notifications.new_quiz', [], $notifiable->locale),
            'message' => $this->title,
        ];
    }
}
