<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use App\Notifications\Channels\GcmDataChannel;
use NotificationChannels\Gcm\GcmMessage;

class NewNotice extends Notification
{
    use Queueable;

    protected $theme;

    public function setTheme($theme)
    {
        $this->theme = $theme;

        return $this;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array
     */
    public function via()
    {
        return [GcmDataChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed $notifiable
     * @return \NotificationChannels\Gcm\GcmMessage;
     */
    public function toGcm($notifiable)
    {
        return GcmMessage::create()
            ->badge(1)
            ->title(__('notice.notifications.new_notice', [], $notifiable->locale))
            ->message($this->theme);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'badge' => 1,
            'title' => __('notice.notifications.new_notice', [], $notifiable->locale),
            'message' => $this->theme,
        ];
    }
}
