<?php

namespace App\Notifications\ApiTest;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use NotificationChannels\Gcm\GcmChannel;
use NotificationChannels\Gcm\GcmMessage;

class ApiTestPassed extends Notification
{
    use Queueable;

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via()
    {
        return [GcmChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \NotificationChannels\Gcm\GcmMessage;
     */
    public function toGcm($notifiable)
    {
        return GcmMessage::create()
          ->badge(1)
          ->title(config('app.name') . ' ' . __('push.apitest.title', [], $notifiable->locale))
          ->message(__('push.apitest.message', [], $notifiable->locale) . ' ' . date('d.m.Y H:i:s'))
          ;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'badge' => 1,
            'title' => config('app.name') . ' ' . __('push.apitest.title', [], $notifiable->locale),
            'message' => __('push.apitest.message', [], $notifiable->locale) . ' ' . date('d.m.Y H:i:s'),
        ];
    }
}
