<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class QuizResultFree extends Model
{
    //
    protected $table = 'quiz_result';

    protected $visible = ['free_answer_value'];

    public static function boot()
    {
        parent::boot();

        static::addGlobalScope('free_answer_value', function (Builder $builder) {
            $builder->where('free_answer_value', '!=', null);
        });
    }
}
