<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QuizAnswer extends Model
{
    //
    protected $table = 'quiz_answer';
    protected $fillable = ['quiz_id', 'text'];
    protected $hidden = ['created_at', 'updated_at', 'quiz_id'];

    public function quiz() {
        return $this->belongsTo('App\Models\Quiz', 'quiz_id', 'id');
    }

    public function results() {
        return $this->hasMany('App\Models\QuizResult', 'quiz_answer_id', 'id');
    }

    public function getPercentAttribute(){
        $results = $this->results()->count();
        $allVariants = QuizResult::where('quiz_id', $this->quiz_id)->count();
        if($allVariants) {
            return round($results * 100 / $allVariants, 2);
        } else {
            return '';
        }

    }

}
