<?php

namespace App\Models\PermissionManager;

use Backpack\PermissionManager\app\Models\Role as BackpackRole;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

/**
 * Class Role
 *
 * @property string $name
 * @property string $created_at
 * @property string $updated_at
 *
 * @property \Illuminate\Database\Eloquent\Collection $permissions
 * @property \Illuminate\Database\Eloquent\Collection $users
 *
 * @package App\Models\PermissionManager
 */
class Role extends BackpackRole
{
    public static function someoneRoleAccess()
    {
        return DB::select('SELECT COUNT(*) AS count FROM role_users WHERE user_id = ? AND object_id = ?', [Auth::user()->id, config('app.object.id')])[0]->count;
    }
}
