<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use App\Models\ClaimImage;
use Illuminate\Support\Facades\DB;

class Claim extends Model {

    use CrudTrait;

    /*
   |--------------------------------------------------------------------------
   | GLOBAL VARIABLES
   |--------------------------------------------------------------------------
   */

    protected $table = 'claims';

    protected $fillable = [
        'user_id',
        'created_at',
        'need_at',
        'type_id',
        'phone',
        'status',
        'images',
        'apartment_id',
        'claim_text',
    ];
    protected $appends = ['images'];
    protected $hidden = ['updated_at', 'object_id', 'user_id', 'type_id', 'apartment_id'];


    public function getType($id) {
        return ClaimType::find($id);
    }

    public static function claimStatuses() {
        return [
            0 => 'New',
            1 => 'In work',
            2 => 'Rejected',
            3 => 'Done',
        ];
    }

    public function getStatusNameHtml() {
        $status = $this->attributes['status'];
        return $status !== NULL ? "<span class='status-name-value' data-id='".$this->id."'>" . trans('claims.statuses.' . self::claimStatuses()[$status]) . "</span>" : "";
    }

    public function getStatusName() {
        $status = $this->attributes['status'];
        return $status !== NULL ? "<span class='status-name-value'>" . trans('claims.statuses.' . self::claimStatuses()[$status]) . "</span>" : "";
    }

    public function getTypeText() {
        $type_id = $this->attributes['type_id'];
        return $type_id ? $this->getType($type_id)->text : "";
    }

    public function getUserFlatNumber() {
        $user_id = $this->attributes['user_id'];
        return $user_id;
    }

    public function getClaimText() {
        return $this->attributes['claim_text'];
    }

    public function getApartmentNumberAttribute() {
        $apartment = Apartment::find($this->attributes['apartment_id']);

        if ($apartment instanceof Apartment) {
            $number = $apartment->number;
        } else {
            $number = null;
        }

        return $number;
    }

    public function getImagesAttribute() {
        return $this->images();
    }

    public function images() {
        return $this->hasMany('App\Models\ClaimImage', 'claim_id', 'id');
    }

}
