<?php

namespace App\Models;

use App\Models\PermissionManager\Permission;
use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\CrudTrait;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Spatie\Translatable\HasTranslations;

/**
 * Class Object
 *
 * @property int    $id
 * @property string $name
 * @property string $address
 * @property string $sip_server_address
 * @property string $sip_server_port
 * @property string $concierge_sip_number
 * @property string $created_at
 * @property string $updated_at
 *
 * @package App\Models
 */
class Building extends Model
{

    use CrudTrait;
    use HasTranslations;

    /*
   |--------------------------------------------------------------------------
   | GLOBAL VARIABLES
   |--------------------------------------------------------------------------
   */


    protected $table = 'objects';
    protected $primaryKey = 'id';
    protected $fillable = [
        'name', 'address',
        'sip_server_address',
        'sip_server_port',
        'concierge_sip_number',
       ];

    public $translatable = ['name', 'address'];


    public static function boot()
    {
        parent::boot();

        self::created(function (self $model) {
            $model->giveFullAccessPermissionsToCurrentUser();
        });
    }

    public static function availableForCurrentUser()
    {
        if ($user = Auth::user()) {
            $getAccessableObjectsByPermissions = $user->getAccessableObjectsByPermissions()->toArray();

            return static::all()->filter(function (self $object) use ($getAccessableObjectsByPermissions) {
                return in_array($object->id, $getAccessableObjectsByPermissions);
            });
        }

        return collect();
    }

    /**
     * @throws \Spatie\Permission\Exceptions\PermissionDoesNotExist
     */
    public function giveFullAccessPermissionsToCurrentUser()
    {
        if ($user = Auth::user()) {
            $userSpatiePermissions = $user->spatiePermissions();
            /** @var \App\Models\PermissionManager\Permission $fullAccessPermission */
            $fullAccessPermission = Permission::findByName(Permission::FULL_ACCESS);

            $currentFullAccessToObjectPermission =
                $userSpatiePermissions
                    ->wherePivot('object_id', $this->id)
                    ->wherePivot('permission_id', $fullAccessPermission->id);

            if ($currentFullAccessToObjectPermission->count() == 0) {
                $userSpatiePermissions->attach(
                    $fullAccessPermission->id,
                    ['object_id' => $this->id]
                );

                $user->forgetCachedPermissions();
            }
        }
    }

    /**
     * @return \App\Models\Object
     */
    public static function getFromCookie()
    {
        if ($encryptedObjectId = Cookie::get('object')) {
            if ($object = static::find((int)$encryptedObjectId)) {
                return $object;
            }
        }

        return new static();
    }
}
