<?php

namespace App\Models;

use Backpack\CRUD\CrudTrait;
use Illuminate\Database\Eloquent\Model;

class Answer extends Model
{
    use CrudTrait;

    protected $fillable = [
        'text',
        'apartment',
        'text',
        'is_viewed',
        'user_id',
        'is_concierge',
        'review_id'
    ];

    public function setNotViewed()
    {
        $this->is_viewed = false;
        $this->save();
    }

    public function getStatusAttribute() {
        return (bool) $this->is_viewed;
    }
}
