<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Http\Controllers\Admin\CameraCrudController;

class CameraRequest extends \Backpack\CRUD\app\Http\Requests\CrudRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return \Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:255',
            'rtsp_link' => 'required|max:255'
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        $attributes = [];

        foreach (CameraCrudController::$displayed_fields_names as $attribute_name) {
            $attributes[$attribute_name] = __("cameras.crud_fields.$attribute_name");
        }

        return $attributes;
    }

    /**
     * Get the validation messages that apply to the request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            //
        ];
    }
}
