<?php

namespace App\Http\Middleware;

use App\Models\Apartment;
use Closure;

class isEmptyObject
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     *
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $object_id = config('app.object.id');

        if($object_id) {
            $apartments_count = Apartment::where('object_id', $object_id)
                ->where('is_local', 0)
                ->count();

            if($apartments_count == 0) {
                return redirect('/admin/apartment-generation');
            }
        }

        return $next($request);
    }
}
