<?php

namespace App\Http\Middleware;

use App\Models\ActivityLog;
use Carbon\Carbon;
use Closure;
use Illuminate\Support\Facades\Auth;

class LogActivity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        $apartment = $user->apartment();
        $date = Carbon::now();
        if ($apartment) {
            $alreadyLogged = ActivityLog::where('user_id', $user->id)
                ->where('updated_at', '>', $date->subMinutes(30))
                ->where('apartment_id', $apartment->id)
                ->get()->toArray();
            if (empty($alreadyLogged)) {
                ActivityLog::create([
                    'short_date_text' => $date->format('Y-m-d'),
                    'user_id' => $user->id,
                    'apartment_id' => $apartment->id,
                ]);
            }
        }
        return $next($request);
    }
}
