<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

/**
 * Class HasAnyPermissionMiddleware
 *
 * @package App\Http\Middleware
 */
class HasAnyPermissionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::guest()) {
            abort(403);
        }

        if (Auth::user()->hasAnyPermissionInAnyObject()) {
            return $next($request);
        }

        abort(403);
    }
}
