<?php

namespace App\Http\Middleware;

use App\Models\Building;
use Closure;
use Illuminate\Support\Facades\Auth;

class BuildingApi
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        /** @var \App\Models\Object $currentObject */
        $currentObject = null;

        if (Auth::check() && Auth::user()->device()->first()->apartment) {
            $currentObject = Auth::user()->device()->first()->apartment->object;
        }

        if (!$currentObject) {
            $currentObject = Building::first();
        }

        config([
            'app.object.id' => $currentObject->id,
            'app.object.name' => $currentObject->name,
            'app.object.address' => $currentObject->address,
        ]);

        return $next($request);
    }
}
