<?php

namespace App\Http\Middleware;

use App\Models\Building as ObjectModel;
use Closure;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Schema;

class Building
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Installer::isFirstObjectCreated()) {
            try {
                $objectsTableExists = Schema::hasTable('objects');
            } catch (\Exception $e) {
                $objectsTableExists = false;
            }

            if ($objectsTableExists) {
                /** @var \App\Models\Object $currentObject */
                $currentObject = null;

                if ($encryptedObjectCookie = $request->cookie('object')) {
                    if ($objectId = (int)Crypt::decrypt($encryptedObjectCookie)) {
                        $currentObject = ObjectModel::find($objectId);
                    }
                }

                if (!$currentObject) {
                    if ($currentObject = ObjectModel::first()) {
                        Cookie::queue(Cookie::forever('object',
                            (int)$currentObject->id));
                    }
                }

                if ($currentObject) {
                    config([
                        'app.object.id' => $currentObject->id,
                        'app.object.name' => $currentObject->name,
                        'app.object.address' => $currentObject->address,
                    ]);
                }
            }
        }

        return $next($request);
    }
}
