<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Laravel\Passport\Http\Middleware\CheckForAnyScope;
use Laravel\Passport\Http\Middleware\CheckScopes;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \App\Http\Middleware\Locale::class,
        \App\Http\Middleware\Building::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // \Illuminate\Session\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\IsActive::class,
            \App\Http\Middleware\SetUserActivity::class,
        ],

        'api' => [
            'throttle:60,1',
            'bindings',

            \App\Http\Middleware\BuildApiResponse::class,
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth' => \Illuminate\Auth\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'role' => Middleware\RoleMiddleware::class,
        'permission' => Middleware\PermissionMiddleware::class,
        'hasAnyPermission' => Middleware\HasAnyPermissionMiddleware::class,
        'scopes' => CheckScopes::class,
        'scope' => CheckForAnyScope::class,
        'localisation' => Middleware\LocalisationMiddleware::class,
        'object.api' => Middleware\BuildingApi::class,
        'api-acs' => Middleware\ApiAcsMiddleware::class,
        'isFullLicense' => Middleware\IsFullLicense::class,
        'isFullLicenseApi' => Middleware\IsFullLicenseApi::class,
        'isEmptyObject' => Middleware\isEmptyObject::class,
        'isNotEmptyObject' => Middleware\isNotEmptyObject::class,
        'logActivity' => Middleware\LogActivity::class,
    ];
}