<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

/**
 * Class PushTokenController
 *
 * @package App\Http\Controllers\Mock
 */
class PushTokenController extends BaseMockController
{
    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function setToken(Request $request)
    {
        $faker = FakerFactory::create();

        try {
            $this->validate($request, [
                'push_token' => 'required|filled',
            ]);
        } catch (ValidationException $validationException) {
            $errorMessages = [];
            $failedValidationRules = $validationException->validator->failed();

            if (isset($failedValidationRules['push_token'])) {
                $errorMessages['push_token'] = 'Поле Push token содержит недопустимое значение.';
                if (isset($failedValidationRules['push_token']['Required'])) {
                    $errorMessages['push_token'] = 'Поле Push token обязательно для заполнения.';
                }
            }

            return $this->badRequestJsonResponse($errorMessages);
        }

        return $this->jsonResponse([
            'id' => $faker->numberBetween(1, 10000),
            'phone' => $faker->e164PhoneNumber,
            'email' => $faker->email,
            'name' => $faker->name,
            'created_at' => $faker->date() . ' ' . $faker->time(),
            'updated_at' => $faker->date() . ' ' . $faker->time(),
            'push_token' => $request->push_token,
        ]);
    }
}
