<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;

/**
 * Class NotificationController
 *
 * @package App\Http\Controllers\Mock
 */
class NotificationController extends BaseMockController
{
    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserNotifications(Request $request)
    {
        $userNotifications = [];

        $faker = FakerFactory::create();
        if ($faker->boolean(50)) {
            $userNotificationsCount = $faker->numberBetween(1, 5);
            for ($i = 1; $i <= $userNotificationsCount; ++$i) {
                $userNotifications[] = [
                    'id' => $faker->numberBetween(1, 1000),
                    'theme' => $faker->sentence(),
                    'text' => $faker->realText(),
                    'actual_to_date' => $faker->date() . ' ' . $faker->time(),
                    'is_viewed' => $faker->boolean(50),
                ];
            }

        }

        return response()->json([
            'notifications' => $userNotifications,
        ]);
    }

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
     */
    public function markUserNotificationAsRead(Request $request)
    {
        return $this->emptyJsonResponse();
    }
}
