<?php
namespace App\Http\Controllers\Mock;

use Faker\Factory as FakerFactory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

/**
 * Class CameraController
 *
 * @package App\Http\Controllers\Mock
 */
class CameraController extends BaseMockController
{
    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getUserCameras(Request $request)
    {
        $userCameras = [];

        $faker = FakerFactory::create();
        if ($faker->boolean(50)) {
            $userCamerasCount = $faker->numberBetween(1, 5);
            for ($i = 1; $i <= $userCamerasCount; ++$i) {
                $userCameras[] = [
                    'id' => $faker->numberBetween(1, 1000),
                    'name' => $faker->sentence(),
                    'rtsp_link' => $faker->url,
                ];
            }
        }

        return response()->json([
            'cameras' => $userCameras,
        ]);
    }
}
