<?php

namespace App\Http\Controllers\ApiTest;

use App\Models\Apartment;
use App\Notifications\ApiTest\ApiTestPassed;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Notification;

class ApiTestController extends Controller
{
    public function sendpush(Request $request)
    {
        $rules = [
          'email' => 'required|email|exists:users',
        ];

        $this->validate($request, $rules);

        $user = User::where(['email'=>$request->email])->first();

        $devices = $user->devices()
          ->where('push_token', '!=', '')
          ->get()
          ->unique('push_token');

        Notification::send($devices, new ApiTestPassed());

        return $devices;
    }


    public function apartment(Apartment $apartment)
    {
        return $apartment->with('users')->get();
    }

    public function optionalToken(Request $request)
    {
        $user = $request->user('api');
        return $user;
    }

}
