<?php

namespace App\Http\Controllers\Admin;

use Mail;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Building;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Mockery\Exception;

class DevTeamController extends Controller
{

    public function index() {
        return view('devteam.form_feedback');
    }

    public function feedback(Request $request) {
        $this->validate($request, [
            'user_message' => 'required'
        ],
        [
            'required' =>  trans('devteam.validate.required')
        ]);

        $email_from = env('MAIL_FROM_ADDRESS', 'no-reply@smartru.com');
        $emails = env('MAIL_DEV_TEAM_ADDRESS', 'mkovtun@smartru.com');
        $email_to = null;
        $email_cc = null;

        if(strpos($emails, ',') !== false) {
            $emails_group = explode(',', $emails);
            $email_to = array_shift($emails_group);
            $email_cc = array_map('trim', $emails_group);
        } else {
            $email_to = $emails;
        }

        if(!empty($email_from) && !empty($email_to)) {
            $dateTimeString = Carbon::now('UTC')->addHour(3)->format('d.m.Y H:i:s');
            $user_id = Auth::user()->id;
            $user_fields = User::findOrFail($user_id);
            
            $object = Building::findOrFail(config('app.object.id'));

            $company_name = Config::get('settings.company_name');

            $subject = (empty($company_name) ?: $company_name) . ' '
                . 'сообщение для команды разработки';

            $data = [
                'url' => url('/'),
                'datetime_string' => $dateTimeString,
                'user' => $user_fields,
                'user_message' => $request->get('user_message'),
                'host' => \Request::getClientIp(),
                'object' => $object,
                'company_name' => $company_name,
            ];


            Mail::send('emails.dev_team_feedback', $data, function ($message) use ($email_from, $email_to, $email_cc, $subject) {
              $message->subject($subject);
              $message->from($email_from);
              $message->to($email_to);

              if (!empty($email_cc)) {
                $message->cc($email_cc);
              }
            });


            if (Mail::failures()) {
                \Alert::error(trans('devteam.email.error_send'))->flash();
            }

            \Alert::success(trans('devteam.email.success_send'))->flash();

        } else {
            \Alert::error(trans('devteam.email.error_send'))->flash();
        }

         return back();
    }

    public function show() {
        return redirect()->action('\App\Http\Controllers\Admin\DevTeamController@index');
    }
}
