<?php

namespace App\Http\Controllers\Admin;

use App\Models\PermissionManager\Permission;
use App\Traits\Admin\Ordering;
use App\Traits\PermissionManager\CheckingPermissions;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Illuminate\Support\Facades\Auth;

// VALIDATION: change the requests to match your own file names if you need form validation
use App\Http\Requests\Claim_typeRequest as StoreRequest;
use App\Http\Requests\Claim_typeRequest as UpdateRequest;

class ClaimTypeCrudController extends CrudController
{
    use CheckingPermissions, Ordering;

    public static $displayFields = [
      'text'
    ];

    /**
     * ClaimTypeCrudController constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->applyCheckingPermissions([[
            [Permission::CLAIM_TYPES_FULL_ACCESS],
            ['create', 'store', 'edit', 'update', 'destroy'],
        ], [
            [Permission::CLAIM_TYPES_FULL_ACCESS, Permission::CLAIM_TYPES_VIEW_ACCESS],
            ['index']
        ]]);
    }

    public function setup()
    {

        /*
        |--------------------------------------------------------------------------
        | BASIC CRUD INFORMATION
        |--------------------------------------------------------------------------
        */
        $this->crud->setModel('App\Models\ClaimType');
        $this->crud->setRoute(config('backpack.base.route_prefix') . '/claims/types');
        $this->crud->setEntityNameStrings(__('claims.claims_types_singular'), __('claims.claims_types_plural'));

        $this->applyBackpackPermissions();

        /*
        |--------------------------------------------------------------------------
        | BASIC CRUD INFORMATION
        |--------------------------------------------------------------------------
        */

        $this->crud->addField([
          'name' => 'text',
          'label' => __('claims.crud_fields.text'),
          'type' => 'text',
          'attributes' => [
            'id' => 'text_claims_type',
          ],
        ]);

        // ------ CRUD COLUMNS
        foreach (self::$displayFields as $field) {
          $localizedFieldName = __("claims.crud_fields.$field");

          $this->crud->addColumn([
            'name' => $field,
            'label' => $localizedFieldName,
            'type' => 'text',
          ]);
        }

        $this->setButtons();
    }

    public function store(StoreRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::storeCrud($request);
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
    }

    public function update(UpdateRequest $request)
    {
        // your additional operations before save here
        $redirect_location = parent::updateCrud($request);
        // your additional operations after save here
        // use $this->data['entry'] or $this->crud->entry
        return $redirect_location;
    }

    protected function setButtons()
    {
        $this->crud->removeAllButtons();

        if (Auth::user()->can(Permission::CLAIM_TYPES_FULL_ACCESS)) {
            $this->crud->addButton('top', 'create', 'view', 'crud::buttons.create');
            $this->crud->addButton('line', 'update', 'view', 'crud::buttons.update');
            $this->crud->addButton('line', 'delete', 'view', 'crud::buttons.delete');
        }
    }

    public function show($id){
        Abort(404);
    }


    /**
     * Переопределение необходимо для сортировки ненастраиваемых полей
     *
     * @return array|\Backpack\CRUD\app\Http\Controllers\Operations\JSON
     * @throws \Backpack\CRUD\Exception\AccessDeniedException
     */
    public function search()
    {
        $this->crud->hasAccessOrFail('list');

        $totalRows = $filteredRows = $this->crud->count();
        $startIndex = $this->request->input('start') ?: 0;
        // if a search term was present
        if ($this->request->input('search') && $this->request->input('search')['value']) {
            // filter the results accordingly
            $this->crud->applySearchTerm($this->request->input('search')['value']);
            // recalculate the number of filtered rows
            $filteredRows = $this->crud->count();
        }
        // start the results according to the datatables pagination
        if ($this->request->input('start')) {
            $this->crud->skip($this->request->input('start'));
        }
        // limit the number of results according to the datatables pagination
        if ($this->request->input('length')) {
            $this->crud->take($this->request->input('length'));
        }
        // overwrite any order set in the setup() method with the datatables order
        $rawSortedEntries = null;
        $sortedEntries = collect();
        if ($this->request->input('order')) {
            //dd(1);
            $column_number = $this->request->input('order')[0]['column'];
            $column_direction = $this->request->input('order')[0]['dir'];
            $column = $this->crud->findColumnById($column_number);

            $customOrder = true;
            $table = $this->crud->getModel()->getTable();
            switch ($column['name']) {
                // По столбцу название
                case 'text':
                    $rawSortedEntries = $this->sortBySimpleRow($table, 'text', [
                        'object' => false
                    ]);
                    break;
                default:
                    $customOrder = false;
                    if ($column['tableColumn']) {
                        // clear any past orderBy rules
                        $this->crud->query->getQuery()->orders = null;
                        // apply the current orderBy rules
                        $this->crud->orderBy($column['name'], $column_direction);
                    }
                    break;
            }

            // Если сортировка кастомная, то сформировать коллекцию объектов
            if ($customOrder) {
                $sortedEntries = $this->createOrderedObjectsByIds('App\Models\ClaimType', $rawSortedEntries);
            }
        }

        // Если сортировка кастомная, то присваиваем отсортированные записи
        $entries = $sortedEntries->count()? $sortedEntries : $this->crud->getEntries();

        return $this->crud->getEntriesAsJsonForDatatables($entries, $totalRows, $filteredRows, $startIndex);
    }
}
