<?php
namespace App\Http\Controllers\Admin;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use App\Models\Camera;
use App\Http\Requests\CameraRequest as UpdateRequest;

class CameraSaveAjaxController extends CrudController {
    //Заполняем связи камеры и квартиры и получаем ссылку для редиректа
    public function updateCameraToFlats(UpdateRequest $request) {
        $cameraID = $request->post('id');
        $arApartments = $request->post('apartments');
        $camera = Camera::find($cameraID);
        //исключаем дубли
        $arIsFlats = $camera->apartments()->get();
        foreach ($arIsFlats as $flat) {
            if (in_array($flat['id'], $arApartments)) {
                $key = array_search($flat['id'],$arApartments);
                unset($arApartments[$key]);
            }
        }
        $camera->apartments()->attach($arApartments);
        $site_addres = env('APP_URL');
        if (!(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')) {
            $site_addres = str_replace('http:','https:', $site_addres);
        }

        $redirect_location = parent::performSaveAction($cameraID);
        $redirect_location['redirect_url'] = $site_addres.'/admin/camera'.$redirect_location['redirect_url'];
        return $redirect_location;
    }
}