<?php
/**
 * Created by PhpStorm.
 * User: alipinskaya
 * Date: 25.07.18
 * Time: 10:58
 */

namespace App\Helpers;

use GuzzleHttp\Client;
use Exception;
use GuzzleHttp\Exception\RequestException;

class AcsHttpRequestHelper
{
    protected $client;
    protected $headers;

    protected $use_guzzle;

    /**
     * AcsHttpRequestHelper constructor.
     *
     * @param bool $isAddLicenseKeyToHeaders
     */
    public function __construct(bool $isAddLicenseKeyToHeaders = true, array $options = [])
    {
        $this->use_guzzle = (isset($options['guzzle']) && is_bool($options['guzzle']))? $options['guzzle'] : false;

        $this->client = new Client([
            'base_uri' => env('APP_LICENSE_SERVER'),
            'verify' => false,
        ]);


        $this->headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json'
        ];

        if ($isAddLicenseKeyToHeaders) {
            $this->headers['App-Licence-Key'] = md5(env('APP_LICENSE_KEY'));
        }
    }

    public function sendGet($url)
    {
        return $this->sendWithoutBody($url);
    }

    /**
     * @param $url
     * @param array $body
     * @return array
     */
    public function sendPost($url, array $body)
    {
        return $this->sendWithBody('POST', $url, $body);
    }

    /**
     * @param $url
     * @param array $body
     * @return array
     */
    public function sendDelete($url, array $body)
    {
        return $this->sendWithBody('DELETE', $url, $body);
    }

    /**
     * @param $url
     * @param array $body
     * @return array
     */
    public function sendPut($url, array $body)
    {
        return $this->sendWithBody('PUT', $url, $body);
    }

    protected function sendWithBody($method, $url, $body)
    {
        try {
            $response = $this->client->request($method, $url, [
                'headers' => $this->headers,
                'body' => \GuzzleHttp\json_encode($body)
            ]);

            $result = [
                'status' => $response->getStatusCode(),
                'body' => json_decode($response->getBody()->getContents())
            ];
        } catch (RequestException $e) {
            $result = [
                'status' => $e->getCode(),
                'message' => $e->getMessage()
            ];
        }
        return $result;
    }

    protected function sendWithoutBody($url)
    {
        try {
            $response = $this->client->request('GET', $url, [
                'headers' => $this->headers,
            ]);

            // If guzzle lib is needed
            if ($this->use_guzzle) {
                $body = \GuzzleHttp\json_decode($response->getBody()->getContents());
            } else {
                $body = json_decode($response->getBody()->getContents());
            }

            $result = [
                'status' => $response->getStatusCode(),
                'body' => $body
            ];
        } catch (RequestException $e) {
            $result = [
                'status' => $e->getCode(),
                'message' => $e->getMessage()
            ];
        }
        return $result;
    }
}