<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\App;

class Kernel extends ConsoleKernel {

    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\PushSend\NewQuizPushSend::class,
        Commands\PushSend\NewAdvertPushSend::class,
        Commands\PushSend\NewNoticePushSend::class,
        Commands\CheckQuizFilled::class,
        \Laravel\Passport\Console\KeysCommand::class,
        \Laravel\Passport\Console\ClientCommand::class,
        \App\Console\Commands\PassportApi::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule $schedule
     *
     * @return void
     */
    protected function schedule(Schedule $schedule) {
        // $schedule->command('inspire')
        //          ->hourly();

        $schedule->command(Commands\PushSend\NewQuizPushSend::class)
            ->everyMinute();

        $schedule->command(Commands\PushSend\NewAdvertPushSend::class)
            ->everyMinute();

        $schedule->command(Commands\PushSend\NewNoticePushSend::class)
            ->everyMinute();

        $schedule->command(Commands\CheckQuizFilled::class)
            ->everyMinute();

        if (App::environment(['staging'])) {
            $schedule->command(Commands\RunApiTests::class)
                ->daily();
        }
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands() {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
