<?php

namespace App\Console\Commands;

use App\Notifications\ApiTestError;
use App\Notifications\ApiTestsFailed;
use Illuminate\Console\Command;
use App\Models\Setting;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;

class RunApiTests extends Command {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'RunApiTests {--output : Show output of phpunit}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Running api tests';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {

        $root = '/var/www/trueip';

        Artisan::call('migrate:refresh', ['--database' => 'testing']);
        $output = [];
        exec('./vendor/phpunit/phpunit/phpunit', $output);

        if ($this->option('output')) {
            dd($output);
        }

        if (preg_match('/(Failures)/', $output[count($output) - 1])) {
            Notification::route('slack', env('SLACK_WEBHOOK_URL', ''))
                ->notify(new ApiTestsFailed);

            Log::info(print_r($output, TRUE));
            $header = "Content-type: text/plain; charset=windows-1251 \r\n";
            $header .= "From: <tech@trueip.smartru.com> \r\n";
            $subject = "Ошибки регулярного тестирования api на сайте TrueIP";
            $msg = "Полный текст ошибок можно посмотреть в логах на сервере: root@192.168.20.95, путь к файлу: " . $root . "/storage/logs/laravel.log";
            mail(env('TECH_MAIL', 'for_tech@example.com'), $subject, iconv("utf8", "windows-1251", $msg), $header);
        }

        // restore user group and file permissions
        exec('chown www-data:www-data -R ' . $root . '/storage ' . $root . '/bootstrap/cache');
        exec('chmod -R ug+rwx ' . $root . '/storage ' . $root . '/bootstrap/cache');
    }
}
