<?php

namespace App\Console\Commands\PushSend;

use App\Models\Quiz;
use App\Notifications\NewQuiz;
use App\Notifications\NewQuizDefault;
use Carbon\Carbon;

class NewQuizPushSend extends BasePushSend {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'QuizPush:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sending push notifications for new quiz';


    public function handle() {
        $quizzes = Quiz::with('destinations')
            ->where('push_sent', 0)
            ->whereHas('destinations')
            ->whereDate('start_at', '<=', Carbon::now())
            ->get();

        foreach ($quizzes as $quiz) {
            $notification_default = (new NewQuizDefault())->setName($quiz->title);
            $notification = (new NewQuiz())->setName($quiz->title);

            $this->sendToMany($quiz, $notification, $notification_default);
        }
    }
}
